//=============================================================================
// EdenMenuUI.js – Menü links neben Kisho ♡ mit Click-Sound, Fadeout und Klickblock während des Fades
// Fix: Klicks während Fadeout deaktiviert ✨ + Buttons werden deaktiviert statt nur per Flag geblockt
// by Yui Nya (⁠✿⁠≧⁠ᆺ⁠≦⁠)
//=============================================================================

(() => {
  let isFadingToGame = false; // Schutz vor Klicks während Fade

  Scene_Title.prototype.createCommandWindow = function () {
    this._commandWindow = new Window_Command(new Rectangle(0, 0, 0, 0));
    this.addWindow(this._commandWindow);
    this._commandWindow.deactivate();
    this._commandWindow.hide();

    const commands = [
      { label: "Neues Spiel", action: () => {
          AudioManager.playSe({ name: "konbini", volume: 90, pitch: 100, pan: 0 });
          AudioManager.fadeOutBgm(2);
          this.disableAllButtons();
          this.startFadeAndGame();
        }
      },
      { label: "Fortsetzen", action: () => {
          AudioManager.playSe({ name: "Cursor1", volume: 80, pitch: 100, pan: 0 });
          SceneManager.push(Scene_Load);
        }
      },
      { label: "Optionen", action: () => {
          AudioManager.playSe({ name: "Cursor1", volume: 80, pitch: 100, pan: 0 });
          SceneManager.push(Scene_Options);
        }
      },
      { label: "KhaosEden", action: () => {
          AudioManager.playSe({ name: "Cursor2", volume: 70, pitch: 120, pan: 0 });
          window.open("https://www.khaoseden.com", "_blank");
        }
      },
      { label: "Join Discord", action: () => {
          AudioManager.playSe({ name: "Cursor2", volume: 70, pitch: 120, pan: 0 });
          window.open("https://discord.gg/X2VtpsB98p", "_blank");
        }
      },
      { label: "Instagram", action: () => {
          AudioManager.playSe({ name: "Cursor2", volume: 70, pitch: 120, pan: 0 });
          window.open("https://www.instagram.com/khaoseden.dev/", "_blank");
        }
      },
      { label: "Spiel beenden", action: () => {
          AudioManager.playSe({ name: "Cancel2", volume: 90, pitch: 100, pan: 0 });
          SceneManager.exit();
        }
      },
    ];

    this._edenButtons = [];

    const buttonWidth = 400;
    const buttonHeight = 56;
    const buttonSpacing = 14;
    const baseX = 40;
    const baseY = 100;

    commands.forEach((entry, i) => {
      const container = new Sprite();
      const btnBitmap = new Bitmap(buttonWidth, buttonHeight);

      const textPadding = 24;
      const bgWidth = 160;
      const bgHeight = 40;
      const bgX = textPadding;
      const bgY = (buttonHeight - bgHeight) / 2;
      btnBitmap.fillRect(bgX, bgY, bgWidth, bgHeight, "rgba(0, 0, 0, 0.4)");

      btnBitmap.fontSize = 30;
      btnBitmap.fontFace = 'M PLUS Rounded 1c';
      btnBitmap.textColor = "#ffffff";
      btnBitmap.outlineColor = "#000000";
      btnBitmap.outlineWidth = 4;
      btnBitmap.drawText(entry.label, textPadding, 0, buttonWidth - textPadding * 2, buttonHeight, "left");

      const btn = new Sprite(btnBitmap);
      container.addChild(btn);
      container.x = baseX;
      container.y = baseY + i * (buttonHeight + buttonSpacing);

      container.setClickHandler(entry.action);
      container._clickEnabled = true;

      container.update = function () {
        Sprite.prototype.update.call(this);
        const hovered = this._clickEnabled && TouchInput.x >= this.x && TouchInput.x <= this.x + buttonWidth &&
                        TouchInput.y >= this.y && TouchInput.y <= this.y + buttonHeight;
        this.scale.x = this.scale.y = hovered ? 1.05 : 1.0;
        this.alpha = hovered ? 1 : 0.95;
      };

      this.addChild(container);
      this._edenButtons.push(container);
    });
  };

  Scene_Title.prototype.disableAllButtons = function () {
    this._edenButtons.forEach(btn => btn._clickEnabled = false);
  };

  Scene_Title.prototype.startFadeAndGame = function () {
    isFadingToGame = true;

    const fadeSprite = new ScreenSprite();
    fadeSprite.setBlack();
    fadeSprite.opacity = 0;
    this.addChild(fadeSprite);

    let frame = 0;
    const fadeDuration = 60 * 5;
    const interval = setInterval(() => {
      frame++;
      fadeSprite.opacity = Math.min(255, Math.floor((frame / fadeDuration) * 255));
      if (frame >= fadeDuration) {
        clearInterval(interval);
        setTimeout(() => {
          this.commandNewGame();
        }, 1000);
      }
    }, 1000 / 60);
  };

  Sprite.prototype.setClickHandler = function (callback) {
    this._clickHandler = callback;
  };

  const _update = Scene_Title.prototype.update;
  Scene_Title.prototype.update = function () {
    _update.call(this);
    if (TouchInput.isTriggered()) {
      this._edenButtons.forEach((btn) => {
        if (!btn._clickEnabled) return;
        const hovered = TouchInput.x >= btn.x && TouchInput.x <= btn.x + 400 &&
                        TouchInput.y >= btn.y && TouchInput.y <= btn.y + 56;
        if (hovered && btn._clickHandler) {
          btn._clickHandler();
        }
      });
    }
  };
})();
